///////////////////////////////////////////////////////////////////////////////////////////////
//
// MeeSoft Image Analyzer demo plugin
// ----------------------------------
// Version:   2003-06-14
// Maintain:  Michael Vinther    |     mv@logicnet.dk
//
// Last changes:
//
library DemoPlugin;

uses
  SysUtils, Classes, Windows, Forms, AnalyzerPlugins, Dialogs;

{$R *.RES}

function RegisterPlugin(CallBack: TAnalyzerCallback): LongBool; stdcall;
var
  Item : TMakeMenuItem;
  AnalyzerWindowHandle : THandle;
begin
  AnalyzerCallback:=CallBack;
  Result:=Assigned(AnalyzerCallback);

  FillChar(Item,SizeOf(Item),0);
  if Result then
  begin
    Item.Tag:=1;
    Item.Menu:='Plugins|Demo';
    Item.Caption:='Invert';
    Item.Hint:='Logical NOT on all pixels';
    Result:=AnalyzerCallback(cmdMakeMenuItem,@Item);
  end;
  if Result then
  begin
    AnalyzerCallback(cmdGetMainWindowHandle,@AnalyzerWindowHandle);
    Application.Handle:=AnalyzerWindowHandle;
  end;
end;

function ProcessImage(Tag: Integer; Image: PImageContainer): Integer; stdcall;
var
  I : Integer;
begin
  Result:=1;

  case Tag of
    1 : if Image^.PixelFormat in [$1,$3] then
        begin
          with Image^ do for I:=0 to Height*BytesPerLine-1 do Map^[I]:=not Map^[I];
          Result:=0;
        end
        else MessageDlg('Only 8 or 24 bit images supported',mtInformation,[mbOk],0);
  end;
end;

exports
  RegisterPlugin, ProcessImage;
end.

